Imports DiaryEvent
Partial Class SecureDiary_AddEvent
    Inherits System.Web.UI.Page

    Protected Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init
 
        Dim EventBeingEdited As New DiaryEvent(CLng(Request.QueryString("EventId")))
        eventNameTextBox.Text = EventBeingEdited.EventName
        eventDescriptionTextBox.Text = EventBeingEdited.EventDescription
        dayShownLabel.Text = EventBeingEdited.EventDate.Day & " " & MonthName(EventBeingEdited.EventDate.Month) & " " & EventBeingEdited.EventDate.Year


        Dim NewListItem As ListItem, HourCount, MinuteCount

        For HourCount = 0 To 23
            If HourCount < 10 Then
                NewListItem = New ListItem("0" & HourCount, HourCount.ToString)
            Else
                NewListItem = New ListItem(HourCount.ToString, HourCount.ToString)
            End If
            If EventBeingEdited.EventDate.Hour = HourCount Then
                NewListItem.Selected = True
            End If
            StartHourDropDownList.Items.Add(NewListItem)
        Next

        For MinuteCount = 0 To 59
            If MinuteCount < 10 Then
                NewListItem = New ListItem("0" & MinuteCount.ToString, MinuteCount.ToString)
            Else
                NewListItem = New ListItem(MinuteCount.ToString, MinuteCount.ToString)
            End If
            If EventBeingEdited.EventDate.Minute = MinuteCount Then
                NewListItem.Selected = True
            End If
            StartMinuteDropDownList.Items.Add(NewListItem)
        Next
        Dim itemToSelect As ListItem
        itemToSelect = eventDurationDropDownList.Items.FindByValue(EventBeingEdited.EventDuration.ToString())
        itemToSelect.Selected = True

        EventBeingEdited = Nothing
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If IsPostBack Then
            Dim EventBeingEdited As New DiaryEvent(CLng(Request.QueryString("EventId")))
            EventBeingEdited.EventDuration = eventDurationDropDownList.SelectedItem.Value
            EventBeingEdited.EventName = eventNameTextBox.Text
            EventBeingEdited.EventDescription = eventDescriptionTextBox.Text
            EventBeingEdited.EventDate = New Date(EventBeingEdited.EventDate.Year, EventBeingEdited.EventDate.Month, EventBeingEdited.EventDate.Day, CInt(StartHourDropDownList.SelectedValue), CInt(StartMinuteDropDownList.SelectedValue), 0)
            EventBeingEdited.Save()

            Dim DayPageURL As String = "DayView.aspx?Day=" & EventBeingEdited.EventDate.Day.ToString()
            DayPageURL = DayPageURL & "&Month=" & EventBeingEdited.EventDate.Month.ToString()
            DayPageURL = DayPageURL & "&Year=" & EventBeingEdited.EventDate.Year.ToString()
            EventBeingEdited = Nothing

            Response.Redirect(DayPageURL)
        End If
    End Sub

    Protected Sub saveButton_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles saveButton.Click

    End Sub
End Class
